<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface ProductionrateproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionrateproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionrateproduct primary key
 	 */
	public function delete($productionRateProductId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionrateproduct productionrateproduct
 	 */
	public function insert($productionrateproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionrateproduct productionrateproduct
 	 */
	public function update($productionrateproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductionRateId($value);

	public function queryByProductId($value);

	public function queryByRate($value);

	public function queryByQuantity($value);

	public function queryByUserId($value);

	public function queryByTheDate($value);

	public function queryByConditions($value);


	public function deleteByProductionRateId($value);

	public function deleteByProductId($value);

	public function deleteByRate($value);

	public function deleteByQuantity($value);

	public function deleteByUserId($value);

	public function deleteByTheDate($value);

	public function deleteByConditions($value);


}
?>